<?php
   /*
    * tables.inc
    *
    * Expects a result handler, the maximum number of rows to show and the
    * upper and lower limits, the latter being optional parameters
    */
   function makeTable($result,$maxhits,$lower=1,$upper=100000) {
      $nrows = SQL_num_rows($result);
      $upper = min(($maxhits+$lower-1),$nrows,$upper);
      if ($lower > 1 ) {
         for ($i=1; $i < $lower; $i++) {
            $temp = SQL_fetch_array($result);
         }
      }
      $table = "<DIV ALIGN=\"CENTER\">\n<TABLE CELLPADDING=4 BORDER
                WIDTH=\"90%\">\n";
      for ($i=$lower; $i<=$upper; $i++) {
         $rec = SQL_fetch_array($result);
         $wrlfile = "raw/" . $rec["metal"] . "/wrl/" . $rec["site_id"] . ".wrl";
         $minipdb =  "raw/" . $rec["metal"] . "/pdb/" . $rec["site_id"] .
                     ".pdb";
         $table .= "<TR ALIGN=\"CENTER\">\n<TD>\n";
         $table .= "<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0
                    WIDTH=\"100%\">\n";
         $table .= "<TR>\n";

         /* site info: id, metal, number of ligands */
         $table .= "<TD BGCOLOR=\"#FFE4B5\" WIDTH=\"30%\">\n <B>[" . $i .
                   "]</B>";
         $table .= "MDB Site ID: <B>" . $rec["site_id"] . "</B></TD>\n";
         $table .= "<TD ALIGN=\"CENTER\" WIDTH=\"30%\">Metal: <B>" .
                   $rec["metal"] . "</B></TD>\n";
         $table .= "<TD ALIGN=\"CENTER\" WIDTH=\"40%\">Number of ligands: <B>";
         $table .= $rec["num_ligands"] .  "</B></TD>\n</TR>\n";

         /* download wrl, pdb or view using java viewer */
         $table .= "<TR ALIGN=\"CENTER\">\n";
         $table .= "<TD BGCOLOR=\"#00FFFF\">Download: <A HREF=\"". $wrlfile .
                   "\">VRML 2.0 file</A></TD>\n";
         $table .= "<TD BGCOLOR=\"#00FFFF\"><A HREF=\"" . $minipdb . 
                   "\">Mini-PDB file</A></TD>\n";
         $table .= "<TD BGCOLOR=\"#00FFFF\">";
         $table .= "<A HREF=\"/remote/remote_siteid.php?site_id[]=";
         $table .= $rec["site_id"] . "\" TARGET=\"viewer\">
                   Interactive 3-D view</A>";
         $table .= "</TD>\n";

         /* source info: PDB */
         $table .= "<TR ALIGN=\"CENTER\">\n";
         $table .= "<TD VALIGN=\"MIDDLE\">Source: <B>PDB</B></TD>\n";
         $table .= "<TD>ID: <B>" . strtoupper($rec["source_id"]) .  "</B></TD>";

         /* links to the pages about this protein */
         $table .= "<TD ROWSPAN=2>";
         $table .= "\t<TABLE BORDER=1 WIDTH=\"100%\" CELLSPACING=0
                             CELLPADDING=0>";

         /* the PDB's  new Structure Explorer at the RCSB */
         $table .= "\t<TR><TD BGCOLOR=\"#D3D3D3\" ALIGN=\"CENTER\">";
         $table .= "<SMALL><A HREF=\"http://www.rcsb.org/\" TARGET=\"rcsb\">
                    PDB</A> RCSB Explorer";
         $table .= " for <A HREF=\"http://www.rcsb.org/pdb/cgi/explore.cgi?
                    pdbId=";
         $table .= strtoupper($rec["source_id"]) . "\" TARGET=\"rcsb\">";
         $table .= strtoupper($rec["source_id"]) . "</A>";

         /* and NIH's Molecules R US page */
         $table .= "\t</SMALL></TD></TR><TR><TD BGCOLOR=\"#D3D3D3\"
                                                ALIGN=\"CENTER\">";
         $table .= "<SMALL><A HREF=\"http://webasaurus.dcrt.nih.gov/
                                     cgi-bin/pdb\"";
         $table .= "TARGET=\"molrus\">Molecules R US</A>";
         $table .= " page for <A HREF=\"http://molbio.info.nih.gov/
                                        cgi-bin/moldraw?";
         $table .= strtoupper($rec["source_id"]) . "\" TARGET=\"molrus\">";
         $table .= strtoupper($rec["source_id"]) . "</A>";
         $table .= "\t</SMALL></TD></TR></TABLE>";
         $table .= "</TD>\n</TR>\n";

         /* short description from the PDB headers */
         $table .= "<TR ALIGN=\"CENTER\">\n<TD COLSPAN=2>\n";
         $table .= "<I>Description:</I> <SMALL>" .
                   substr($rec["description"],0,200) . "</SMALL>\n";
         $table .= "</TD>\n</TR>\n</TABLE>\n</TD></TR>";
      }
      $table .= "</TABLE></DIV>";
      echo ($table);
   }
   /* generates a form that allows to page through results */
   function makeForm($form_str,$sql_str,$nrows,$max,$lower,$upper) {
      $sf = "<FORM ACTION=\"prev_next.php\" METHOD=\"POST\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"form_str\" VALUE=\"" . $form_str .
             "\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"sql_str\" VALUE=\"" . $sql_str .
             "\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"nrows\" VALUE=\"" . $nrows .
             "\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"max\" VALUE=\"" . $max . "\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"lower\" VALUE=\"" . $lower .
             "\">\n";
      $sf .= "<INPUT TYPE=\"HIDDEN\" NAME=\"upper\" VALUE=\"" . $upper .
             "\">\n";
      $sf .= "<INPUT TYPE=\"SUBMIT\" NAME=\"leftbutton\" VALUE=\"Results: " .
             $lower . " to " . $upper . "\">\n";
      $sf .= "</FORM>\n";
      echo ($sf);
   }
?>

